<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Collection;

use Erlage\Photogram\System;
use Erlage\Photogram\Constants\ServerConstants;
use Erlage\Photogram\Data\Models\Setting\SettingEnum;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;
use Erlage\Photogram\Data\Tables\Collection\CollectionTable;
use Erlage\Photogram\Data\Dtos\Collection\CollectionDisplayImageDTO;

final class CollectionBuilder implements InterfaceCollectionSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitCollectionSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            CollectionTable::OWNER_USER_ID => '',

            CollectionTable::DISPLAY_TITLE => '',

            CollectionTable::DISPLAY_IMAGE => (new CollectionDisplayImageDTO())
                -> setHost(SettingEnum::STORAGE_DISK_LOCAL)
                -> setFilespace(CollectionDisplayImageDTO::FILESPACE_COLLECTION)
                -> setIdentifier(ServerConstants::SS_TEXT_FILE_NAME_PLACEHOLDER_COLLECTION),

            CollectionTable::STAMP_REGISTRATION => System::isoDateTime(),
            CollectionTable::STAMP_LAST_UPDATE  => System::isoDateTime(),
        );
    }

    public function dispense(): CollectionModel
    {
        return CollectionModel::createFromData(
            array(
                // owner user id

                CollectionTable::OWNER_USER_ID => $this -> ownerUserId

                ?? $this -> defaultValues[CollectionTable::OWNER_USER_ID],

                // display title

                CollectionTable::DISPLAY_TITLE => $this -> displayTitle

                ?? $this -> defaultValues[CollectionTable::DISPLAY_TITLE],

                // display image

                CollectionTable::DISPLAY_IMAGE => $this -> displayImage

                ?? $this -> defaultValues[CollectionTable::DISPLAY_IMAGE],

                // stamp registration

                CollectionTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[CollectionTable::STAMP_REGISTRATION],

                // stamp last update

                CollectionTable::STAMP_LAST_UPDATE  => $this -> stampLastUpdate

                ?? $this -> defaultValues[CollectionTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
